/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import mod.beethoven92.betterendforge.common.init.ModItems;
import mod.beethoven92.betterendforge.common.tileentity.EChestTileEntity;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class EndChestTileEntityRenderer
extends TileEntityRenderer<EChestTileEntity> {
    private static final HashMap<Block, RenderType[]> LAYERS = Maps.newHashMap();
    private static RenderType[] defaultLayer = new RenderType[]{RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("textures/entity/chest/normal.png")), RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("textures/entity/chest/normal_left.png")), RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("textures/entity/chest/normal_right.png"))};
    private static final int ID_NORMAL = 0;
    private static final int ID_LEFT = 1;
    private static final int ID_RIGHT = 2;
    private final ModelRenderer partA;
    private final ModelRenderer partC = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer partB;
    private final ModelRenderer partRightA;
    private final ModelRenderer partRightC;
    private final ModelRenderer partRightB;
    private final ModelRenderer partLeftA;
    private final ModelRenderer partLeftC;
    private final ModelRenderer partLeftB;

    public EndChestTileEntityRenderer(TileEntityRendererDispatcher blockEntityRenderDispatcher) {
        super(blockEntityRenderDispatcher);
        this.partC.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 9.0f, 14.0f, 0.0f);
        this.partA = new ModelRenderer(64, 64, 0, 0);
        this.partA.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.partA.field_78797_d = 9.0f;
        this.partA.field_78798_e = 1.0f;
        this.partB = new ModelRenderer(64, 64, 0, 0);
        this.partB.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.partB.field_78797_d = 8.0f;
        this.partRightC = new ModelRenderer(64, 64, 0, 19);
        this.partRightC.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 9.0f, 14.0f, 0.0f);
        this.partRightA = new ModelRenderer(64, 64, 0, 0);
        this.partRightA.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.partRightA.field_78797_d = 9.0f;
        this.partRightA.field_78798_e = 1.0f;
        this.partRightB = new ModelRenderer(64, 64, 0, 0);
        this.partRightB.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.partRightB.field_78797_d = 8.0f;
        this.partLeftC = new ModelRenderer(64, 64, 0, 19);
        this.partLeftC.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 9.0f, 14.0f, 0.0f);
        this.partLeftA = new ModelRenderer(64, 64, 0, 0);
        this.partLeftA.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.partLeftA.field_78797_d = 9.0f;
        this.partLeftA.field_78798_e = 1.0f;
        this.partLeftB = new ModelRenderer(64, 64, 0, 0);
        this.partLeftB.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.partLeftB.field_78797_d = 8.0f;
    }

    public void render(EChestTileEntity entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        World world = entity.func_145831_w();
        boolean worldExists = world != null;
        BlockState blockState = worldExists ? entity.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.func_235901_b_((Property)ChestBlock.field_196314_b) ? (ChestType)blockState.func_177229_b((Property)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockState.func_177230_c();
        if (entity.hasChest()) {
            block = entity.getChest();
        }
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractChestBlock = (AbstractChestBlock)block;
            boolean isDouble = chestType != ChestType.SINGLE;
            float f = ((Direction)blockState.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.5, 0.5, 0.5);
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrices.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper propertySource = worldExists ? abstractChestBlock.func_225536_a_(blockState, world, entity.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float pitch = ((Float2FloatFunction)propertySource.apply(ChestBlock.func_226917_a_((IChestLid)entity))).get(tickDelta);
            pitch = 1.0f - pitch;
            pitch = 1.0f - pitch * pitch * pitch;
            int blockLight = ((Int2IntFunction)propertySource.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(light);
            IVertexBuilder vertexConsumer = EndChestTileEntityRenderer.getConsumer(vertexConsumers, block, chestType);
            if (isDouble) {
                if (chestType == ChestType.LEFT) {
                    this.renderParts(matrices, vertexConsumer, this.partLeftA, this.partLeftB, this.partLeftC, pitch, blockLight, overlay);
                } else {
                    this.renderParts(matrices, vertexConsumer, this.partRightA, this.partRightB, this.partRightC, pitch, blockLight, overlay);
                }
            } else {
                this.renderParts(matrices, vertexConsumer, this.partA, this.partB, this.partC, pitch, blockLight, overlay);
            }
            matrices.func_227865_b_();
        }
    }

    private void renderParts(MatrixStack matrices, IVertexBuilder vertices, ModelRenderer modelPart, ModelRenderer modelPart2, ModelRenderer modelPart3, float pitch, int light, int overlay) {
        modelPart2.field_78795_f = modelPart.field_78795_f = -(pitch * 1.5707964f);
        modelPart.func_228308_a_(matrices, vertices, light, overlay);
        modelPart2.func_228308_a_(matrices, vertices, light, overlay);
        modelPart3.func_228308_a_(matrices, vertices, light, overlay);
    }

    private static RenderType getChestTexture(ChestType type, RenderType[] layers) {
        switch (type) {
            case LEFT: {
                return layers[1];
            }
            case RIGHT: {
                return layers[2];
            }
        }
        return layers[0];
    }

    public static IVertexBuilder getConsumer(IRenderTypeBuffer provider, Block block, ChestType chestType) {
        RenderType[] layers = LAYERS.getOrDefault(block, defaultLayer);
        return provider.getBuffer(EndChestTileEntityRenderer.getChestTexture(chestType, layers));
    }

    static {
        ModItems.ITEMS.getEntries().forEach(item -> {
            Block block;
            if (item.get() instanceof BlockItem && (block = ((BlockItem)item.get()).func_179223_d()) instanceof ChestBlock) {
                String name = block.getRegistryName().func_110623_a();
                LAYERS.put(block, new RenderType[]{RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/chest/" + name + ".png")), RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/chest/" + name + "_left.png")), RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/chest/" + name + "_right.png"))});
            }
        });
    }
}

